/* $(), addEvent(), insertAfter, getElementsByClass, getCookie, setCookie, 
   deleteCookie are from http://www.dustindiaz.com/top-ten-javascript/

   addEvent() and EventCache are under the CC-LGPL license.

   The rest are too obvious to be protected.
*/

function $() {
  var elements = new Array();
  for (var i = 0; i < arguments.length; i++) {
    var element = arguments[i];
    if (typeof element == 'string')
      element = document.getElementById(element);
    if (arguments.length == 1)
      return element;
    elements.push(element);
  }
  return elements;
}

function toggle(obj,caller, color) {
  var obj = document.getElementById(obj);
  if ( obj.style.display != 'none' ) {
    obj.style.display = 'none';
    if (caller && color) caller.style.color=''
  }
  else {
    obj.style.display = '';
    if (caller && color) caller.style.color = color
  }
}

function addEvent( obj, type, fn ) {
  if (obj.addEventListener) {
    obj.addEventListener( type, fn, false );
    EventCache.add(obj, type, fn);
  }
  else if (obj.attachEvent) {
    obj["e"+type+fn] = fn;
    obj[type+fn] = function() { obj["e"+type+fn]( window.event ); }
    obj.attachEvent( "on"+type, obj[type+fn] );
    EventCache.add(obj, type, fn);
  }
  else {
    obj["on"+type] = obj["e"+type+fn];
  }
}

var EventCache = function(){
  var listEvents = [];
  return {
    listEvents : listEvents,
    add : function(node, sEventName, fHandler){
      listEvents.push(arguments);
    },
    flush : function(){
      var i, item;
      for(i = listEvents.length - 1; i >= 0; i = i - 1){
        item = listEvents[i];
        if(item[0].removeEventListener){
          item[0].removeEventListener(item[1], item[2], item[3]);
        };
        if(item[1].substring(0, 2) != "on"){
          item[1] = "on" + item[1];
        };
        if(item[0].detachEvent){
          item[0].detachEvent(item[1], item[2]);
        };
        item[0][item[1]] = null;
      };
    }
  };
}();

addEvent(window,'unload',EventCache.flush);

function addLoadEvent(func) {addEvent(window,'load',EventCache.flush);}

function getElementsByClass(searchClass,node,tag) {
  var classElements = new Array();
  if ( node == null )
    node = document;
  if ( tag == null )
    tag = '*';
  var els = node.getElementsByTagName(tag);
  var elsLen = els.length;
  var pattern = new RegExp('(^|\\\\s)'+searchClass+'(\\\\s|$)');
  for (i = 0, j = 0; i < elsLen; i++) {
    if ( pattern.test(els[i].className) ) {
      classElements[j] = els[i];
      j++;
    }
  }
  return classElements;
}

function insertAfter(parent, node, referenceNode) {
  parent.insertBefore(node, referenceNode.nextSibling);
}

if (!Array.prototype.indexOf)
{
  Array.prototype.indexOf = function(elt /*, from*/)
  {
    var len = this.length;

    var from = Number(arguments[1]) || 0;
    from = (from < 0) ? Math.ceil(from) : Math.floor(from);
    if (from < 0)
      from += len;

    for (; from < len; from++)
    {
      if (from in this &&
          this[from] === elt)
        return from;
    }
    return -1;
  };
}

function getCookie( name ) {
  var start = document.cookie.indexOf( name + "=" );
  var len = start + name.length + 1;
  if ( ( !start ) && ( name != document.cookie.substring( 0, name.length ) ) ) {
    return null;
  }
  if ( start == -1 ) return null;
  var end = document.cookie.indexOf( ';', len );
  if ( end == -1 ) end = document.cookie.length;
  return unescape( document.cookie.substring( len, end ) );
}

function setCookie( name, value, expires, path, domain, secure ) {
  var today = new Date();
  today.setTime( today.getTime() );
  if ( expires ) {
    expires = expires * 1000 * 60 * 60 * 24;
  }
  var expires_date = new Date( today.getTime() + (expires) );
  document.cookie = name+'='+escape( value ) +
    ( ( expires ) ? ';expires='+expires_date.toGMTString() : '' ) + //expires.toGMTString()
    ( ( path ) ? ';path=' + path : '' ) +
    ( ( domain ) ? ';domain=' + domain : '' ) +
    ( ( secure ) ? ';secure' : '' );
}

function deleteCookie( name, path, domain ) {
  if ( getCookie( name ) ) document.cookie = name + '=' +
      ( ( path ) ? ';path=' + path : '') +
      ( ( domain ) ? ';domain=' + domain : '' ) +
      ';expires=Thu, 01-Jan-1970 00:00:01 GMT';
}

request = null
handler = null
handlerData = null

function receiveXMLDoc()
{
    if (request.readyState == 4)
    {
      var r = request;
      var h = handler;
      request = null;
      handler = null;
      if (r.status == 200) // only if "OK"
      {
        if (h != null)
        h(r.responseText,handlerData)
      }
      else
      {
        alert("There was a problem retrieving the remote data:\n" + r.statusText);
      }
    }
}

function loadXMLDoc(url, responder, data, opaque)
{
    // branch for native XMLHttpRequest object
    if (request) return false;

    if (window.XMLHttpRequest)
    {
        request = new XMLHttpRequest();
    }
    else if (window.ActiveXObject)
    {
        request = new ActiveXObject("Microsoft.XMLHTTP");
    }
    if (request)
    {
      handler = responder
      handlerData = opaque;
      request.onreadystatechange = receiveXMLDoc;
      if (data)
      {
       request.open("POST", url, true);
       request.setRequestHeader("Content-length",data.length)
       request.setRequestHeader("Content-type","application/x-www-form-urlencoded")
       request.send(data);
      }
      else
      {
       request.open("GET", url, true);
       request.send(null);
      }
    // branch for IE/Windows ActiveX version
    }
}

function submitForm(form, responder, opaque)
{
  var data = "";
  for (i=0; i<form.elements.length; i++) 
  {
     var obj = form.elements[i]; /*obj*/
     if (!obj.name) continue;
     switch (obj.tagName)
     {
      case "INPUT":
        switch (obj.type)
        {
          case "checkbox": 
            if (obj.checked) 
              data += escape(obj.name) + "=" + escape(obj.value) + "&";
            break;
          case "radio":
            if (obj.checked) 
              data += escape(obj.name) + "=" + escape(obj.value) + "&";
            break;
          default:
            data += escape(obj.name) + "=" + escape(obj.value) + "&";
        }
        break;
        
      case "TEXTAREA":
        data += escape(obj.name) + "=" + escape(obj.value) + "&";
        break;
        
      case "SELECT":      
        if (obj.selectedIndex != -1)
        { 
          var value = '';
          if (obj.multiple)
          {            
            for (var j=0; j<obj.options.length; j++)
             if (obj.options[j].selected)
              value += ',' + obj.options[j].value;
            value = value.substr(1);
          }
          else value = obj.value;
          data += escape(obj.name) + "=" + escape(value) + "&";
        }
     }
  }
  loadXMLDoc(form.getAttribute('action'),responder,data,opaque);
}

function reload()
{
 window.location.reload()
}

function handleResponse()
{
 var r = request;
 if (!r) return;
 //$('debug').innerHTML += http.readyState +
 if (http.readyState == 4)
 {
  if (http.status >= 400) alert('HTTP error ' + http.status + '\n' + r.page + '\n'+ http.statusText);
  if (http.status == 200)
  {
  request = null
  if (r.handler)
    r.handler(http.responseText);
  }
  else
  {
   if (r.error)
    r.error(http) 
  }
 }
}

function sendRequest(r) // {method: 'GET', page:'https:...', body: '',headers: ['cooke:value'], handler: function() {}}
{
/*if (typeof netscape != "undefined")
{
 netscape.security.PrivilegeManager.enablePrivilege("UniversalBrowserAccess");
 netscape.security.PrivilegeManager.enablePrivilege("UniversalBrowserWrite");
 netscape.security.PrivilegeManager.enablePrivilege("UniversalBrowserRead");
}
*/
 if (request) {alert("busy " + r.page + '\n' + request.page);return false;}
 request = r;
 http.open(r.method,r.page,httpAsync);
 if (r.headers)
  for (var i in r.headers)
  {
   var h = r.headers[i].split(/:\s*/);
   try
    {
     http.setRequestHeader(h[0],h[1])
     } catch(x)
     {
     alert(x + '\n' + h.toSource())
     }
  }

 if (httpAsync && (r.async == null || r.async == true))
 {
  http.onreadystatechange = handleResponse;
  http.send(r.body);
  return true;
 }
 else
 {
  http.send(r.body);
  request = null
  handleResponse()
  return true;
 }
}
