load('httpd.js')

var server = new HTTPD();

server.debug = true

server.hosts = ['localhost'] //restrict access

//enable programs executed as separate processes
server.handlers["cgi"] = execCGI 

//enable server-parsed JavaScript pages 
server.handlers["jsp"] = execJSP 

//server config
server.forbidden = ['httpd.js','cgi.js','run.js']
server.index = "index.jsp"

//establish a database
database =  new SQLite('data.db');

function escapeSQL(src) {return src.replace(/'/g,"''")}

server.functions["echo"] = function(client,data)
  {
   client.writeln("Content-type: text/plain")
   client.writeln()
   client.writeln(data.toSource())
  }

//intended to be called by AJAX
server.functions["addname"] = function(client,data)
  {
   client.writeln("Content-type: text/plain")
   client.writeln()
   var cmd = "insert into people (name,email) values ('" + escapeSQL(data.name) + "','"+ escapeSQL(data.email) + "')"
   var result = database.exec(cmd)
   client.writeln(result)
  }

//intended to be called by AJAX
server.functions["insert"] = function(client,data)
  {
   client.writeln("Content-type: text/plain")
   client.writeln()
   var table = data.table
   if (!table) return;
   var columns = database.columns(table)
   var fields = ''
   var values = ''
   for each (var c in columns)
   {
    if (!data[c]) continue
    fields += ",'" + escapeSQL(c) + "'"
    values += ",'" + escapeSQL(data[c]) + "'"
   }
   fields = fields.substr(1)
   values = values.substr(1)
   var cmd = "insert into " + table + " (" + fields + ") values (" + values + ")"
   var result = database.exec(cmd)
   if (!result) 
   {
    writeln(cmd)
    writeln(database.error)
   } 
   client.writeln(result)
  }

//CREATE TABLE foobar (id INTEGER PRIMARY KEY AUTOINCREMENT, ...)
//intended to be called by AJAX
server.functions["update"] = function(client,data)
  {
   client.writeln("Content-type: text/plain")
   client.writeln()
   var table = data.table
   delete data.table
   var fields = ''
   var values = ''
   for (var i in data)
   {
    fields += ",'" + escapeSQL(i) + "'"
    values += ",'" + escapeSQL(data[i]) + "'"
   }
   fields = fields.substr(1)
   values = values.substr(1)
   var cmd = "insert into " + table + " (" + fields + ") values (" + values + ")"
   var result = database.exec(cmd)
   client.writeln(result)
  }

server.run();
delete server;

