#pragma hdrfile "jsdb.csm"
#include "rslib.h"
#include "jsdb.h"
#include "rs/wrap_jsdb.h"
#pragma hdrstop

JSPointerBase::JSPointerBase(JSPointerBase* p)
 :Parent(p),Children(false)
 {
  if (Parent) Parent->AddChild(this);
 }

void JSPointerBase::AddChild(JSPointerBase *c)
{
 Children.Add(c);
}

void JSPointerBase::RemoveChild(JSPointerBase *c)
{
 if (!c) return;
 FOREACHBACK(JSPointerBase*d,Children)
  if (d && c) if (c == d)
   {
    c->Parent = NULL;
    Children.AddAt(NULL,i);
    return;
   }
 DONEFOREACH
}

JSPointerBase::~JSPointerBase()
{
}

void JSPointerBase::InvalidateChildren()
{
 FOREACH(JSPointerBase*c,Children)
  if (c)
  {
   c->Parent = NULL;
   c->Close();
  }
 DONEFOREACH
 Children.Flush(); //does not delete the pointers
}

JSBool SuspendGC(JSContext*cx, JSGCStatus flags)
 {return JS_FALSE;}

void
rs_ErrorReporter(JSContext *cx, const char *message, JSErrorReport *report)
{
    GETENV;
    if (!Env->out) return;

    if (!report)
    {
   	Env->out->writestr(message,"\n");
	   return;
    }

    /* Conditionally ignore reported warnings. */
 //  if (JSREPORT_IS_WARNING(report->flags) && !Env->reportWarnings)
 //	 return;

   TChars prefix;

   if (report->filename)
    prefix << report->filename << ":";

   if (report->lineno)
    prefix << report->lineno << "\t";

   // mark the error on screen
   if (report->tokenptr && report->linebuf)
   {
    *Env->out << ((char*)prefix) << report->linebuf;
    if (!strchr(report->linebuf,'\n') && *report->linebuf)
      *Env->out << "\n";

    *Env->out << ((char*)prefix);

    int j = 0;
    for (const char * c = report->linebuf; c != report->tokenptr ; c++)
    {
     if (*c == '\t')
     {
      for (int k = (j + 8) & ~7; j < k; j++)
       {
        *Env->out << ".";
       }
      continue;
     }
    *Env->out << ".";
    j++;
   }

   *Env->out << "^\n";
  }

  if (JSREPORT_IS_WARNING(report->flags))
    {
     *Env->out << "warning";
     if (JSREPORT_IS_STRICT(report->flags))
      *Env->out << " (strict)";
     *Env->out << ": ";
    }

   TStr mout(message);
   RemoveChar(mout,'\r',mout.length());
   RemoveChar(mout,'\n',mout.length());

   Env->out->writestr(prefix,mout,"\n");
}


